document.querySelectorAll('.zoom-image').forEach((img) => {
    img.addEventListener('mousemove', function (e) {
        const { width, height, top, left } = img.getBoundingClientRect();
        const x = e.pageX - left;
        const y = e.pageY - top;

        const xPercent = (x / width) * 100;
        const yPercent = (y / height) * 100;

        img.style.transformOrigin = `${xPercent}% ${yPercent}%`;
        img.style.transform = 'scale(1.5)'; // Ensure zoom is applied during hover
    });

    img.addEventListener('mouseleave', function () {
        this.style.transform = 'scale(1)'; // Reset zoom when mouse leaves
    });
});